VERSION 5.00
Begin VB.Form frmMain 
   Caption         =   "The Enigma Protector Keys Generator"
   ClientHeight    =   7920
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   5685
   LinkTopic       =   "Form1"
   ScaleHeight     =   7920
   ScaleWidth      =   5685
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton btnVerifyFP 
      Caption         =   "Verify from project"
      Height          =   375
      Left            =   3000
      TabIndex        =   37
      Top             =   7440
      Width           =   2535
   End
   Begin VB.CommandButton btnVerify 
      Caption         =   "Verify"
      Height          =   375
      Left            =   120
      TabIndex        =   36
      Top             =   7440
      Width           =   2775
   End
   Begin VB.Frame Frame2 
      Caption         =   "Key Type"
      Height          =   1095
      Left            =   120
      TabIndex        =   32
      Top             =   3600
      Width           =   5415
      Begin VB.ComboBox cbKeyType 
         Height          =   315
         ItemData        =   "frmMain.frx":0000
         Left            =   120
         List            =   "frmMain.frx":0010
         Style           =   2  'Dropdown List
         TabIndex        =   35
         Top             =   600
         Width           =   5175
      End
      Begin VB.OptionButton cbKeyShort 
         Caption         =   "Short Key"
         Height          =   255
         Left            =   2760
         TabIndex        =   34
         Top             =   240
         Width           =   2415
      End
      Begin VB.OptionButton cbKeyLong 
         Caption         =   "Long Key"
         Height          =   255
         Left            =   120
         TabIndex        =   33
         Top             =   240
         Value           =   -1  'True
         Width           =   2175
      End
   End
   Begin VB.TextBox tKey 
      BeginProperty Font 
         Name            =   "Lucida Console"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1575
      Left            =   120
      MultiLine       =   -1  'True
      TabIndex        =   31
      Top             =   5760
      Width           =   5415
   End
   Begin VB.CommandButton bClose 
      Cancel          =   -1  'True
      Caption         =   "Close"
      Height          =   375
      Left            =   120
      TabIndex        =   30
      Top             =   5280
      Width           =   5415
   End
   Begin VB.CommandButton bGenFP 
      Caption         =   "Generate key from project"
      Height          =   375
      Left            =   3000
      TabIndex        =   29
      Top             =   4800
      Width           =   2535
   End
   Begin VB.CommandButton bGet 
      Caption         =   "Generate key"
      Height          =   375
      Left            =   120
      TabIndex        =   28
      Top             =   4800
      Width           =   2775
   End
   Begin VB.Frame Frame1 
      Caption         =   "Secure sections"
      Height          =   1815
      Left            =   120
      TabIndex        =   11
      Top             =   1680
      Width           =   5415
      Begin VB.CheckBox cbSection 
         Caption         =   "Section 16"
         Height          =   195
         Index           =   15
         Left            =   4080
         TabIndex        =   27
         Top             =   1440
         Width           =   1215
      End
      Begin VB.CheckBox cbSection 
         Caption         =   "Section 15"
         Height          =   195
         Index           =   14
         Left            =   4080
         TabIndex        =   26
         Top             =   1080
         Width           =   1215
      End
      Begin VB.CheckBox cbSection 
         Caption         =   "Section 14"
         Height          =   195
         Index           =   13
         Left            =   4080
         TabIndex        =   25
         Top             =   720
         Width           =   1215
      End
      Begin VB.CheckBox cbSection 
         Caption         =   "Section 13"
         Height          =   195
         Index           =   12
         Left            =   4080
         TabIndex        =   24
         Top             =   360
         Width           =   1215
      End
      Begin VB.CheckBox cbSection 
         Caption         =   "Section 12"
         Height          =   195
         Index           =   11
         Left            =   2760
         TabIndex        =   23
         Top             =   1440
         Width           =   1215
      End
      Begin VB.CheckBox cbSection 
         Caption         =   "Section 11"
         Height          =   195
         Index           =   10
         Left            =   2760
         TabIndex        =   22
         Top             =   1080
         Width           =   1215
      End
      Begin VB.CheckBox cbSection 
         Caption         =   "Section 10"
         Height          =   195
         Index           =   9
         Left            =   2760
         TabIndex        =   21
         Top             =   720
         Width           =   1215
      End
      Begin VB.CheckBox cbSection 
         Caption         =   "Section 9"
         Height          =   195
         Index           =   8
         Left            =   2760
         TabIndex        =   20
         Top             =   360
         Width           =   1215
      End
      Begin VB.CheckBox cbSection 
         Caption         =   "Section 8"
         Height          =   195
         Index           =   7
         Left            =   1440
         TabIndex        =   19
         Top             =   1440
         Width           =   1215
      End
      Begin VB.CheckBox cbSection 
         Caption         =   "Section 7"
         Height          =   195
         Index           =   6
         Left            =   1440
         TabIndex        =   18
         Top             =   1080
         Width           =   1215
      End
      Begin VB.CheckBox cbSection 
         Caption         =   "Section 6"
         Height          =   195
         Index           =   5
         Left            =   1440
         TabIndex        =   17
         Top             =   720
         Width           =   1215
      End
      Begin VB.CheckBox cbSection 
         Caption         =   "Section 5"
         Height          =   195
         Index           =   4
         Left            =   1440
         TabIndex        =   16
         Top             =   360
         Width           =   1215
      End
      Begin VB.CheckBox cbSection 
         Caption         =   "Section 4"
         Height          =   195
         Index           =   3
         Left            =   120
         TabIndex        =   15
         Top             =   1440
         Width           =   1215
      End
      Begin VB.CheckBox cbSection 
         Caption         =   "Section 3"
         Height          =   195
         Index           =   2
         Left            =   120
         TabIndex        =   14
         Top             =   1080
         Width           =   1215
      End
      Begin VB.CheckBox cbSection 
         Caption         =   "Section 2"
         Height          =   195
         Index           =   1
         Left            =   120
         TabIndex        =   13
         Top             =   720
         Width           =   1215
      End
      Begin VB.CheckBox cbSection 
         Caption         =   "Section 1"
         Height          =   195
         Index           =   0
         Left            =   120
         TabIndex        =   12
         Top             =   360
         Width           =   1215
      End
   End
   Begin VB.TextBox tbYear 
      Height          =   285
      Left            =   3480
      TabIndex        =   7
      Top             =   1320
      Width           =   735
   End
   Begin VB.TextBox tbMonth 
      Height          =   285
      Left            =   2760
      TabIndex        =   6
      Top             =   1320
      Width           =   495
   End
   Begin VB.TextBox tbDay 
      Height          =   285
      Left            =   2040
      TabIndex        =   5
      Top             =   1320
      Width           =   495
   End
   Begin VB.CheckBox cbExpiration 
      Caption         =   "Key expiration date"
      Height          =   255
      Left            =   120
      TabIndex        =   4
      Top             =   1320
      Width           =   1815
   End
   Begin VB.TextBox tbHardware 
      Height          =   285
      Left            =   2040
      TabIndex        =   3
      Top             =   840
      Width           =   3495
   End
   Begin VB.CheckBox cbHardware 
      Caption         =   "Hardware ID"
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   840
      Width           =   1815
   End
   Begin VB.TextBox tbUserInfo 
      Height          =   285
      Left            =   120
      TabIndex        =   1
      Top             =   360
      Width           =   5415
   End
   Begin VB.Label lbDateFormat 
      Caption         =   "DD/MM/YYYY"
      Height          =   255
      Left            =   4320
      TabIndex        =   10
      Top             =   1320
      Width           =   1215
   End
   Begin VB.Label lbDel 
      Caption         =   "/"
      Height          =   255
      Index           =   1
      Left            =   3340
      TabIndex        =   9
      Top             =   1380
      Width           =   135
   End
   Begin VB.Label lbDel 
      Caption         =   "/"
      Height          =   255
      Index           =   0
      Left            =   2600
      TabIndex        =   8
      Top             =   1380
      Width           =   135
   End
   Begin VB.Label lbUserInfo 
      Caption         =   "User information"
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   2895
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Sub bClose_Click()
  End
End Sub

Private Sub bGenFP_Click()
  Dim KeyParams As TGenKeyParams
  Dim I As Integer
  Dim dwResult As Long
  Dim ProjectFile As String

  ' Clear control
  tKey.Text = ""
  ' Fill key buffer
  KeyParams.Key = String$(1024, 0)
  KeyParams.KeyLen = 1024
  ' Fill User Info buffer
  KeyParams.RegInfo = tbUserInfo.Text & vbNullChar
  KeyParams.RegInfoLen = Len(KeyParams.RegInfo) - 1
  ' Key expiration info
  KeyParams.UseKeyExpiration = cbExpiration.Value
  KeyParams.ExpirationDay = tbDay.Text
  KeyParams.ExpirationMonth = tbMonth.Text
  KeyParams.ExpirationYear = tbYear.Text
  ' Hardware ID
  KeyParams.UseHardwareLocking = cbHardware.Value
  KeyParams.HardwareID = tbHardware.Text
  ' Crypt Sections
  For I = 1 To NUMBER_OF_CRYPTED_SECTIONS
    KeyParams.EncryptedSections(I - 1) = cbSection(I - 1).Value
  Next I
  
  ProjectFile = App.Path
  If Mid(ProjectFile, Len(ProjectFile) - 1, 1) <> "\" Then ProjectFile = ProjectFile & "\"
  ProjectFile = ProjectFile & "default.enigma"
  
  ' Generate reg. key
  dwResult = KG_GenerateRegistrationKeyFromProject(ProjectFile, KeyParams)
  If dwResult = ERROR_OK Then
    tKey.Text = KeyParams.Key
  Else
    Select Case dwResult
      Case ERROR_KEY_BUFFER_NOT_ALLOCATED
        tKey.Text = "ERROR_KEY_BUFFER_NOT_ALLOCATED"
      Case ERROR_KEY_BUFFER_LESS
        tKey.Text = "ERROR_KEY_BUFFER_LESS"
      Case ERROR_REGINFO_BUFFER_NOT_ALLOCATED
        tKey.Text = "ERROR_REGINFO_BUFFER_NOT_ALLOCATED"
      Case ERROR_REGINFO_BUFFER_EMPTY
        tKey.Text = "ERROR_REGINFO_BUFFER_EMPTY"
      Case ERROR_HARDWARE_TYPE_UNKNOWN
        tKey.Text = "ERROR_HARDWARE_TYPE_UNKNOWN"
      Case ERROR_HARDWARE_ID
        tKey.Text = "ERROR_HARDWARE_ID"
      Case ERROR_HARDWARE_BUFFER_NOT_ALLOCATED
        tKey.Text = "ERROR_HARDWARE_BUFFER_NOT_ALLOCATED"
      Case ERROR_HARDWARE_BUFFER_EMPTY
        tKey.Text = "ERROR_HARDWARE_BUFFER_EMPTY"
      Case ERROR_INVALID_CONSTANT_D
        tKey.Text = "ERROR_INVALID_CONSTANT_D"
      Case ERROR_INVALID_CONSTANT_N
        tKey.Text = "ERROR_INVALID_CONSTANT_N"
      Case ERROR_INVALID_CONSTANT_A
        tKey.Text = "ERROR_INVALID_CONSTANT_A"
      Case ERROR_INVALID_CONSTANT_B
        tKey.Text = "ERROR_INVALID_CONSTANT_B"
      Case ERROR_PROJECT_FILE_NOT_FOUND
        tKey.Text = "ERROR_PROJECT_FILE_NOT_FOUND"
      Case ERROR_PROJECT_FILE_INVALID
        tKey.Text = "ERROR_PROJECT_FILE_INVALID"
      Case Else
        tKey.Text = "ERROR_UNKNOWN"
    End Select
  End If
End Sub

Private Sub bGet_Click()
  Dim KeyParams As TGenKeyParams
  Dim I As Integer
  Dim dwResult As Long

  ' Clear control
  tKey.Text = ""
  ' Key type
  If cbKeyLong.Value = True Then
    KeyParams.KeyType = KEY_TYPE_LONG
  End If
  If cbKeyShort.Value = True Then
    KeyParams.KeyType = KEY_TYPE_SHORT
  End If
  ' Key format
  Select Case cbKeyType.ListIndex
    Case 0
      KeyParams.KeyFormat = KEY_FORMAT_10
    Case 1
      KeyParams.KeyFormat = KEY_FORMAT_16
    Case 2
      KeyParams.KeyFormat = KEY_FORMAT_32
    Case 3
      KeyParams.KeyFormat = KEY_FORMAT_64
    Case Else
      KeyParams.KeyFormat = KEY_FORMAT_32
  End Select
  ' Fill key buffer
  KeyParams.Key = String$(1024, 0)
  KeyParams.KeyLen = 1024
  ' Fill User Info buffer
  KeyParams.RegInfo = tbUserInfo.Text & vbNullChar
  KeyParams.RegInfoLen = Len(KeyParams.RegInfo) - 1
  ' Key expiration info
  KeyParams.UseKeyExpiration = cbExpiration.Value
  KeyParams.ExpirationDay = tbDay.Text
  KeyParams.ExpirationMonth = tbMonth.Text
  KeyParams.ExpirationYear = tbYear.Text
  ' Hardware ID
  KeyParams.UseHardwareLocking = cbHardware.Value
  KeyParams.HardwareID = tbHardware.Text
  ' Crypt Sections
  For I = 1 To NUMBER_OF_CRYPTED_SECTIONS
    KeyParams.EncryptedSections(I - 1) = cbSection(I - 1).Value
  Next I
  ' Secure constant (get it from project file)!
  ' or use special utility
  If KeyParams.KeyType = KEY_TYPE_LONG Then
    KeyParams.D = "3K4RHBXV93J75R72XBF68M5GTQ2PDDVCJCQ9ZZ7CXBZYJNY6ASWVB6S3X4JP9TWPBANMW2HSMPAZ7GY5WZF8TQYJ36VUQZQ7J4F6JF" & vbNullChar
    KeyParams.N = "7MSYMACUVPSKBB44WSEF3Q7T6ATNEDQ9D3UGQRP8SYVCXDDEX8TB78PFHWXGR4RVVTWVCSXANQWHDLWF2XTMS7PAA3396RALRP3UUK" & vbNullChar
  End If
  If KeyParams.KeyType = KEY_TYPE_SHORT Then
    KeyParams.D = "5V8YRKNAXCEPB46WAV4RPT95D6WMPHPKFJBXHDVDM" & vbNullChar
    KeyParams.N = "CNC74RPSW3DKWRSGRLDZS3D9G6XRYJ98QWHYX86AT" & vbNullChar
  End If
  KeyParams.A = "F4A190D21E05F4DF387A18CFBB70426E" & vbNullChar
  KeyParams.B = "C7A44A94C94D7F290037E9DACCC2CB23" & vbNullChar
  
  ' Generate reg. key
  dwResult = KG_GenerateRegistrationKey(KeyParams)
  If dwResult = ERROR_OK Then
    tKey.Text = KeyParams.Key
  Else
    Select Case dwResult
      Case ERROR_KEY_BUFFER_NOT_ALLOCATED
        tKey.Text = "ERROR_KEY_BUFFER_NOT_ALLOCATED"
      Case ERROR_KEY_BUFFER_LESS
        tKey.Text = "ERROR_KEY_BUFFER_LESS"
      Case ERROR_REGINFO_BUFFER_NOT_ALLOCATED
        tKey.Text = "ERROR_REGINFO_BUFFER_NOT_ALLOCATED"
      Case ERROR_REGINFO_BUFFER_EMPTY
        tKey.Text = "ERROR_REGINFO_BUFFER_EMPTY"
      Case ERROR_HARDWARE_TYPE_UNKNOWN
        tKey.Text = "ERROR_HARDWARE_TYPE_UNKNOWN"
      Case ERROR_HARDWARE_ID
        tKey.Text = "ERROR_HARDWARE_ID"
      Case ERROR_HARDWARE_BUFFER_NOT_ALLOCATED
        tKey.Text = "ERROR_HARDWARE_BUFFER_NOT_ALLOCATED"
      Case ERROR_HARDWARE_BUFFER_EMPTY
        tKey.Text = "ERROR_HARDWARE_BUFFER_EMPTY"
      Case ERROR_INVALID_CONSTANT_D
        tKey.Text = "ERROR_INVALID_CONSTANT_D"
      Case ERROR_INVALID_CONSTANT_N
        tKey.Text = "ERROR_INVALID_CONSTANT_N"
      Case ERROR_INVALID_CONSTANT_A
        tKey.Text = "ERROR_INVALID_CONSTANT_A"
      Case ERROR_INVALID_CONSTANT_B
        tKey.Text = "ERROR_INVALID_CONSTANT_B"
      Case ERROR_PROJECT_FILE_NOT_FOUND
        tKey.Text = "ERROR_PROJECT_FILE_NOT_FOUND"
      Case ERROR_PROJECT_FILE_INVALID
        tKey.Text = "ERROR_PROJECT_FILE_INVALID"
      Case Else
        tKey.Text = "ERROR_UNKNOWN"
    End Select
  End If
End Sub

Private Sub btnVerify_Click()
  Dim VerifyKey As TVerifyKey
  Dim dwResult As Long
  Dim sResult As String
  
  If tbUserInfo.Text = "" Then
    MsgBox ("User Info field is empty")
    Exit Sub
  End If
  If tKey.Text = "" Then
    MsgBox ("Key field is empty")
    Exit Sub
  End If
  VerifyKey.Key = tKey.Text
  VerifyKey.RegInfo = tbUserInfo.Text
  ' Key type
  If cbKeyLong.Value = True Then
    VerifyKey.KeyType = KEY_TYPE_LONG
  End If
  If cbKeyShort.Value = True Then
    VerifyKey.KeyType = KEY_TYPE_SHORT
  End If
  ' Key format
  Select Case cbKeyType.ListIndex
    Case 0
      VerifyKey.KeyFormat = KEY_FORMAT_10
    Case 1
      VerifyKey.KeyFormat = KEY_FORMAT_16
    Case 2
      VerifyKey.KeyFormat = KEY_FORMAT_32
    Case 3
      VerifyKey.KeyFormat = KEY_FORMAT_64
    Case Else
      VerifyKey.KeyFormat = KEY_FORMAT_32
  End Select
  ' Secure constant (get it from project file)!
  ' or use special utility
  If VerifyKey.KeyType = KEY_TYPE_LONG Then
    VerifyKey.E = "35AL5XHXFAJZUKEUZVFHSQ2Q3BNECXCAFTEPXQ9S8KWNF89XPYNZCXCAUEEXYVGQJAN5MTZ58BUX6MG5FFP2NUX7QXCF2XK5T344GHF" & vbNullChar
    VerifyKey.N = "7MSYMACUVPSKBB44WSEF3Q7T6ATNEDQ9D3UGQRP8SYVCXDDEX8TB78PFHWXGR4RVVTWVCSXANQWHDLWF2XTMS7PAA3396RALRP3UUK" & vbNullChar
  End If
  If VerifyKey.KeyType = KEY_TYPE_SHORT Then
    VerifyKey.E = "3WMT5MUA2J3VG4BE3P3B3T9C74YGC7JEZYF2N323SD" & vbNullChar
    VerifyKey.N = "CNC74RPSW3DKWRSGRLDZS3D9G6XRYJ98QWHYX86AT" & vbNullChar
  End If
  VerifyKey.A = "F4A190D21E05F4DF387A18CFBB70426E" & vbNullChar
  VerifyKey.B = "C7A44A94C94D7F290037E9DACCC2CB23" & vbNullChar
  
  dwResult = KG_VerifyRegistrationInfo(VerifyKey)
  
  Select Case dwResult
    Case ERROR_UNKNOWN
      sResult = "ERROR_UNKNOWN"
    Case ERROR_OK
      sResult = "Valid registration key!" + Chr$(13)
      sResult = sResult + "Key created date: " + Str$(VerifyKey.CreateDay) + "/" + Str$(VerifyKey.CreateMonth) + "/" + Str$(VerifyKey.CreateYear)
    Case ERROR_KEY_BUFFER_NOT_ALLOCATED
      sResult = "ERROR_KEY_BUFFER_NOT_ALLOCATED"
    Case ERROR_KEY_BUFFER_LESS
      sResult = "ERROR_KEY_BUFFER_LESS"
    Case ERROR_REGINFO_BUFFER_NOT_ALLOCATED
      sResult = "ERROR_REGINFO_BUFFER_NOT_ALLOCATED"
    Case ERROR_REGINFO_BUFFER_EMPTY
      sResult = "ERROR_REGINFO_BUFFER_EMPTY"
    Case ERROR_INVALID_CONSTANT_N
      sResult = "ERROR_INVALID_CONSTANT_N"
    Case ERROR_INVALID_CONSTANT_A
      sResult = "ERROR_INVALID_CONSTANT_A"
    Case ERROR_INVALID_CONSTANT_B
      sResult = "ERROR_INVALID_CONSTANT_B"
    Case ERROR_PROJECT_FILE_NOT_FOUND
      sResult = "ERROR_PROJECT_FILE_NOT_FOUND"
    Case ERROR_PROJECT_FILE_INVALID
      sResult = "ERROR_PROJECT_FILE_INVALID"
    Case ERROR_INVALID_CONSTANT_E
      sResult = "ERROR_INVALID_CONSTANT_E"
    Case ERROR_INVALID_KEYTYPE
      sResult = "ERROR_INVALID_KEYTYPE"
    Case ERROR_INVALID_REGINFO
      sResult = "ERROR_INVALID_REGINFO"
  End Select
  MsgBox (sResult)
End Sub

Private Sub btnVerifyFP_Click()
  Dim VerifyKey As TVerifyKey
  Dim dwResult As Long
  Dim sResult As String
  Dim ProjectFile As String
  
  If tbUserInfo.Text = "" Then
    MsgBox ("User Info field is empty")
    Exit Sub
  End If
  If tKey.Text = "" Then
    MsgBox ("Key field is empty")
    Exit Sub
  End If
  VerifyKey.Key = tKey.Text
  VerifyKey.RegInfo = tbUserInfo.Text
  
  ProjectFile = App.Path
  If Mid(ProjectFile, Len(ProjectFile) - 1, 1) <> "\" Then ProjectFile = ProjectFile & "\"
  ProjectFile = ProjectFile & "default.enigma"
  
  dwResult = KG_VerifyRegistrationInfoFromProject(ProjectFile, VerifyKey)
  
  Select Case dwResult
    Case ERROR_UNKNOWN
      sResult = "ERROR_UNKNOWN"
    Case ERROR_OK
      sResult = "Valid registration key!" + Chr$(13)
      sResult = sResult + "Key created date: " + Str$(VerifyKey.CreateDay) + "/" + Str$(VerifyKey.CreateMonth) + "/" + Str$(VerifyKey.CreateYear)
    Case ERROR_KEY_BUFFER_NOT_ALLOCATED
      sResult = "ERROR_KEY_BUFFER_NOT_ALLOCATED"
    Case ERROR_KEY_BUFFER_LESS
      sResult = "ERROR_KEY_BUFFER_LESS"
    Case ERROR_REGINFO_BUFFER_NOT_ALLOCATED
      sResult = "ERROR_REGINFO_BUFFER_NOT_ALLOCATED"
    Case ERROR_REGINFO_BUFFER_EMPTY
      sResult = "ERROR_REGINFO_BUFFER_EMPTY"
    Case ERROR_INVALID_CONSTANT_N
      sResult = "ERROR_INVALID_CONSTANT_N"
    Case ERROR_INVALID_CONSTANT_A
      sResult = "ERROR_INVALID_CONSTANT_A"
    Case ERROR_INVALID_CONSTANT_B
      sResult = "ERROR_INVALID_CONSTANT_B"
    Case ERROR_PROJECT_FILE_NOT_FOUND
      sResult = "ERROR_PROJECT_FILE_NOT_FOUND"
    Case ERROR_PROJECT_FILE_INVALID
      sResult = "ERROR_PROJECT_FILE_INVALID"
    Case ERROR_INVALID_CONSTANT_E
      sResult = "ERROR_INVALID_CONSTANT_E"
    Case ERROR_INVALID_KEYTYPE
      sResult = "ERROR_INVALID_KEYTYPE"
    Case ERROR_INVALID_REGINFO
      sResult = "ERROR_INVALID_REGINFO"
  End Select
  MsgBox (sResult)
End Sub

Private Sub cbExpiration_Click()
  tbDay.Enabled = cbExpiration.Value
  tbMonth.Enabled = cbExpiration.Value
  tbYear.Enabled = cbExpiration.Value
  lbDel(0).Enabled = cbExpiration.Value
  lbDel(1).Enabled = cbExpiration.Value
  lbDateFormat.Enabled = cbExpiration.Value
End Sub

Private Sub cbHardware_Click()
  tbHardware.Enabled = cbHardware.Value
End Sub

Private Sub Form_Load()
  ' Fill out current date controls
  tbYear.Text = Year(Now)
  tbMonth.Text = Month(Now)
  tbDay.Text = Day(Now)
  
  cbKeyType.ListIndex = 2
  
  Call cbExpiration_Click
  Call cbHardware_Click
End Sub

